#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef struct {
    int index;
    int w, v;
    double ratio;
} Poncho;

int cmp(const void *a, const void *b) {
    Poncho *p1 = (Poncho*)a;
    Poncho *p2 = (Poncho*)b;
    if (p1->ratio > p2->ratio) return -1;
    else if (p1->ratio < p2->ratio) return 1;
    else return 0;
}

int main() {
    int N, W;
    double eps;
    scanf("%d %d %lf", &N, &W, &eps);

    Poncho *ponchos = (Poncho*)malloc(N * sizeof(Poncho));
    for (int i = 0; i < N; i++) {
        scanf("%d %d", &ponchos[i].w, &ponchos[i].v);
        ponchos[i].index = i + 1;
        ponchos[i].ratio = (double)ponchos[i].v / ponchos[i].w;
    }

    qsort(ponchos, N, sizeof(Poncho), cmp);

    int totalW = 0;
    int *chosen = (int*)malloc(N * sizeof(int));
    int k = 0;

    for (int i = 0; i < N; i++) {
        if (totalW + ponchos[i].w <= W) {
            totalW += ponchos[i].w;
            chosen[k++] = ponchos[i].index;
        }
    }

    printf("%d\n", k);
    for (int i = 0; i < k; i++) {
        printf("%d%c", chosen[i], (i == k - 1) ? '\n' : ' ');
    }

    free(ponchos);
    free(chosen);
    return 0;
}